//
//  BIProjectCard.h
//  BIViews
//
//  Created by Eric Hochmeister on 03/03/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <MCApplication/MCWindowController.h>
#import <MCApplication/MCHelpController.h>

@class BIProject, BIClient;
@class MCTVToolbarView;
@class MCSearchField;
@class MCArrayController;
@class BINote;
@class MCTableView;
@class BIURLReference;
@class BITextCheckTextView;

@interface BIProjectCard : MCWindowController {
	
	BIProject* _project;   // contains the actual BIProject which was passed in
	BIClient* _client;
	BOOL createProjectFlag;
	float extraFieldsBoxHeight;
	IBOutlet NSBox* extraFieldsBox;
	IBOutlet NSButton* extraFieldsDisclosure;
	
	IBOutlet NSObjectController* extraFieldNamesController;
	
	IBOutlet NSObjectController* projectController;
	IBOutlet NSArrayController* statesController;
	IBOutlet MCArrayController* urlsController;
	IBOutlet MCArrayController* notesController;
	
	IBOutlet MCTVToolbarView* filesTVToolbar;	
	IBOutlet MCTVToolbarView* notesTVToolbar;
	
	IBOutlet MCTableView* filesTableView;
	IBOutlet MCTableView* notesTableView;
	
	IBOutlet NSButton* dueDateCheckbox;
	IBOutlet NSButton* startDateCheckbox;
	IBOutlet NSButton* completeDateCheckbox;
	IBOutlet NSButton* preferNicknameCheckbox;
	
	IBOutlet MCSearchField* filesSearchField;
	IBOutlet MCSearchField* notesSearchField;
	IBOutlet BITextCheckTextView* noteTextView;
	
	IBOutlet NSButton* cancelButton;

	IBOutlet NSTabView *tabView;
	
	IBOutlet NSTextField *projectTotalField;
	
	
	IBOutlet NSArrayController *workersController;
	IBOutlet NSArrayController *approversController;
	
	IBOutlet NSNumberFormatter *currencyFormatter;
    
    IBOutlet NSTextField *mileageRateField;
    IBOutlet NSTextField *mileageFormatField;
}

- (BIProject *)project;
- (void)setProject:(BIProject *)aProject;

- (BIClient *)client;
- (void)setClient:(BIClient *)aClient;

/*!
    @method     setDefaultValuesForProject:
    @abstract   sets default values for a newly created BIProject
    @discussion this method is used when we are adding a new project. we need to populate
                the project with default values so the UI looks right and we don't mess
                up any integrity checks within the db by storing garbage (uninitialized data)
    @param      aProject - newly created project
    @result     return the modified version of aProject which now contains the default values for a Project
*/
- (BIProject*)setDefaultValuesForProject:(BIProject*)aProject;


/*!
    @method     setupProjectCardWithProject:
    @abstract   sets up the project card given aProject
    @discussion basically initializes the mutableProjectCopy with either a new Project or the project
                which is passed in.
                If an existing BIProject is passed to the method then a copy of that project is made and
                stored in mutableProjectCopy
                If aProject is nil or a project does not exist (we're creating a new one), then create a
                new BIProject, set the default values and then set projectMutableCopy to the new BIProject
                 also sets the client instance variable
    @param      aProject -- if editing a project then an existing BIProject, if creating one, then nil
                aClient -- the client who we're creating a project for.
*/
- (void)setupProjectCardWithProject:(BIProject*)aProject forClient:(BIClient*)aClient;


- (void)setupFilesToolbar;

- (void)setupNotesToolbar;

/*!
    @method     cancelProject:
    @abstract   action invoked when Cancel button is pressed
    @discussion close the window when Cancel button is pressed and do not save changes to project
    @param      sender (description)
    @result     (description)
*/
- (IBAction)cancelProject:(id)sender;

- (IBAction)saveProject:(id)sender;

- (IBAction)delete:(id)sender;

- (IBAction)addFileURL:(id)sender;
- (IBAction)deleteURL:(id)sender;

- (void)openPanelDidEnd:(NSOpenPanel*)openPanel
			 returnCode:(int)returnCode
			contextInfo:(void*)x;

- (BOOL)canAddFileURL;
- (BOOL)canDeleteURL;

- (IBAction)addNote:(id)sender;
- (IBAction)deleteNote:(id)sender;

- (BOOL)canAddNote;
- (BOOL)canDeleteNote;

- (IBAction)addWebURL:(id)sender;
- (BOOL)canAddWebURL;
- (void)addWebURLSheetDidEnd:(NSWindow*)sheet
				  returnCode:(int)returnCode
				 contextInfo:(void*)contextInfo;

// double click action for the files table
- (IBAction)openURL:(id)sender;

- (void)showNote:(BINote *)aNote;
- (void)showLink:(BIURLReference *)aRef;

- (IBAction)toggleExtraFields:(id)sender;

- (IBAction)help:(id)sender;

- (void)applicationWillTerminate:(NSNotification *)aNotification;

- (void)cleanUp;

// overriding close to do clean up 
- (void)close;

@end
